﻿#include  "StdAfx.h"
#include  <szVersion.hpp>
#include  <szRuntimeException.hpp>

SZ_NS_BEG(szpp)

OSVersion::OSVersion() : version(0)
{
  OSVERSIONINFOEX info_ex;
  memset(&info_ex, 0, sizeof(OSVERSIONINFOEX));
  info_ex.dwOSVersionInfoSize = sizeof(OSVERSIONINFOEX);
  if (0 == GetVersionEx(reinterpret_cast<OSVERSIONINFO * >(&info_ex)))
    BOOST_THROW_EXCEPTION(RuntimeException(SZT("Cannot obtain Windows version")) << last_error_info(GetLastError()));

  version = (info_ex.dwMajorVersion << 8) | info_ex.dwMinorVersion;
}

OSVersion::~OSVersion()
{
}

u32 OSVersion::GetVersion()
{
  OSVersion osVersion;
  return osVersion.Get();
}

SZ_NS_END(szpp)
